function EMoutput = fct_EM_estimation(EMinput)
    % this script uses an guess of the estimates of our model to  improve its fit using the EM
    % algorithm. This file used the conditional distribution, conditioning on
    % (t1,t2) geq tlow and (t1,t2) leq thigh
    % this version uses an iterative procedure to solve the ML in each of the M
    % steps

    % retrieve parameters
%     mm_mat = fieldnames( EMinput );
%     for i = 1 : length(mm_mat)
%         eval([cell2mat(mm_mat(i)) '= EMinput.(cell2mat(mm_mat(i)));']);
%     end

    % initial guess for unconditional EM procedure
    % we use estimate from MD procedure
    EMinput.g_vec_ini     = EMinput.g_vec_MD;
    EMinput.mu_vec_ini    = EMinput.mu_vec_MD;
    EMinput.sigma_vec_ini = EMinput.sigma_vec_MD;

    % use unconditional EM refinement as an initial step
    EMUNCoutput = fct_EM_unconditional(EMinput);
    EMoutput.EMUNCoutput = EMUNCoutput;

    if EMinput.produce_graphs== 1
        figure
        subplot(1,3,1)
        hold on
        plot(EMinput.mu_vec_MD,EMUNCoutput.mu_vec,'.')
        plot(EMinput.mu_vec_MD,EMinput.mu_vec_MD,'r:')
        xlabel('initial mu')
        ylabel('after EM mu')
        title('Unconditional EM: mu')
        subplot(1,3,2)
        hold on
        plot(EMinput.sigma_vec_MD,EMUNCoutput.sigma_vec,'.')
        plot(EMinput.sigma_vec_MD,EMinput.sigma_vec_MD,'r:')
        xlabel('initial sigma')
        ylabel('after EM sigma')
        title('Unconditional EM: sigma')
        subplot(1,3,3)
        hold on
        plot(EMinput.g_vec_MD,EMUNCoutput.g_vec,'.')
        plot(EMinput.g_vec_MD,EMinput.g_vec_MD,'r:')
        xlabel('initial g')
        ylabel('after EM g')
        title('Unconditional EM: g')
    end

% initial guess for conditional procedure -- comes from unconditional EM
    EMinput.g_vec_ini     = EMUNCoutput.g_vec;
    EMinput.mu_vec_ini    = EMUNCoutput.mu_vec;
    EMinput.sigma_vec_ini = EMUNCoutput.sigma_vec;

    EMCONDoutput = fct_EM_conditional(EMinput) ;
    EMoutput = EMCONDoutput;
    save(EMinput.filename_out, 'EMinput','EMoutput','EMUNCoutput','EMCONDoutput')    

%%% AKAIKE CRITERIUM
 
if EMinput.do_Akaike == 1
    K  = length(EMCONDoutput.g_vec_max);
    N  = sum(EMinput.data_EM(:,3));    
    toss_vec = [1:1:K-1];  % how many types to toss away
    
    estimates = [EMCONDoutput.g_vec, EMCONDoutput.mu_vec, EMCONDoutput.sigma_vec];
    estimates_sorted = sortrows(estimates);
    AIC_K  = -2*EMCONDoutput.log_like(end)  + 2*(K*3-1) ;
    BIC_K  = -2*EMCONDoutput.log_like(end)  + (K*3-1)*(log(N) - log(2*pi));
    LogL_K = EMCONDoutput.log_like(end);
    
    estimates_reopt = zeros(K,3*length(toss_vec)+1);
    
    estimates_reopt(:,1:3) = estimates;
    
    AKAIKEinput = EMinput;
        
    for r = 1:length(toss_vec);
        number_to_toss = toss_vec(r);
        
        disp('================================================')
        disp(sprintf('Tossing values: loop %d, number truncated %d',r,number_to_toss))

        
        estimates_small = estimates_sorted(1+number_to_toss:end,:);
        % reweight g
        AKAIKEinput.g_vec_ini     = estimates_small(:,1)/sum(estimates_small(:,1));
        AKAIKEinput.mu_vec_ini    = estimates_small(:,2);
        AKAIKEinput.sigma_vec_ini = estimates_small(:,3);
            
        output_name = sprintf('AKAIKEoutput_%d',r);
        AKAIKEoutput = fct_EM_conditional(AKAIKEinput);

        KK = length(AKAIKEoutput.g_vec_max);         
        
        AIC_vec(r) = -2*AKAIKEoutput.log_like_max  + 2*(KK*3-1);
        
        BIC_vec(r) = -2*AKAIKEoutput.log_like_max + (KK*3-1)*( log(N)-log(2*pi));
        
        AKAIKE_log_like_vec(r) = AKAIKEoutput.log_like_max ;
        
        estimates_new = [AKAIKEoutput.g_vec_max AKAIKEoutput.mu_vec_max AKAIKEoutput.sigma_vec_max];
        
        estimates_reopt(1:KK,r*3+1:r*3+3) = estimates_new;     

        EMoutput.estimates_reopt = estimates_reopt;
        EMoutput.AIC_vec = AIC_vec;
        EMoutput.BIC_vec = BIC_vec;
        EMoutput.AKAIKE_log_like_vec = AKAIKE_log_like_vec;    
        EMoutput.AIC_K = AIC_K;
        EMoutput.BIC_K = BIC_K;
        EMoutput.LogL_K = LogL_K;
        save(EMinput.filename_out, 'EMinput','EMoutput','EMUNCoutput','EMCONDoutput')  
            
    end
    

end
    
return
